/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.widget;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import androidx.a.V;
import androidx.a.W;
import androidx.appcompat.f;
import androidx.appcompat.h;
import androidx.appcompat.k;
import androidx.appcompat.l;
import androidx.appcompat.n;
import androidx.appcompat.widget.A;
import androidx.appcompat.widget.H;
import androidx.appcompat.widget.I;
import androidx.appcompat.widget.J;
import androidx.appcompat.widget.K;
import androidx.appcompat.widget.L;
import androidx.appcompat.widget.M;
import androidx.appcompat.widget.N;
import androidx.appcompat.widget.aS;
import androidx.appcompat.widget.z;
import androidx.core.n.c;

@V(a={W.c})
public class ActivityChooserView
extends ViewGroup
implements A {
    private static final String i = "ActivityChooserView";
    final M a;
    private final N j;
    private final View k;
    private final Drawable l;
    final FrameLayout b;
    private final ImageView m;
    final FrameLayout c;
    private final ImageView n;
    private final int o;
    c d;
    final DataSetObserver e = new H(this);
    private final ViewTreeObserver.OnGlobalLayoutListener p = new I(this);
    private aS q;
    PopupWindow.OnDismissListener f;
    boolean g;
    int h = 4;
    private boolean r;
    private int s;

    public ActivityChooserView(Context context) {
        this(context, null);
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, androidx.appcompat.n.Q, n2, 0);
        if (Build.VERSION.SDK_INT >= 29) {
            this.saveAttributeDataForStyleable(context, androidx.appcompat.n.Q, attributeSet, typedArray, n2, 0);
        }
        this.h = typedArray.getInt(androidx.appcompat.n.S, 4);
        Drawable drawable = typedArray.getDrawable(androidx.appcompat.n.R);
        typedArray.recycle();
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.getContext());
        layoutInflater.inflate(androidx.appcompat.k.g, (ViewGroup)this, true);
        this.j = new N(this);
        this.k = this.findViewById(androidx.appcompat.h.Z);
        this.l = this.k.getBackground();
        this.c = (FrameLayout)this.findViewById(androidx.appcompat.h.an);
        this.c.setOnClickListener((View.OnClickListener)this.j);
        this.c.setOnLongClickListener((View.OnLongClickListener)this.j);
        this.n = (ImageView)this.c.findViewById(androidx.appcompat.h.ax);
        FrameLayout frameLayout = (FrameLayout)this.findViewById(androidx.appcompat.h.aq);
        frameLayout.setOnClickListener((View.OnClickListener)this.j);
        frameLayout.setAccessibilityDelegate((View.AccessibilityDelegate)new J(this));
        frameLayout.setOnTouchListener((View.OnTouchListener)new K(this, (View)frameLayout));
        this.b = frameLayout;
        this.m = (ImageView)frameLayout.findViewById(androidx.appcompat.h.ax);
        this.m.setImageDrawable(drawable);
        this.a = new M(this);
        this.a.registerDataSetObserver(new L(this));
        Resources resources = context.getResources();
        this.o = Math.max(resources.getDisplayMetrics().widthPixels / 2, resources.getDimensionPixelSize(androidx.appcompat.f.x));
    }

    @Override
    public void a(z z2) {
        this.a.a(z2);
        if (this.c()) {
            this.b();
            this.a();
        }
    }

    public void a(Drawable drawable) {
        this.m.setImageDrawable(drawable);
    }

    public void a(int n2) {
        String string = this.getContext().getString(n2);
        this.m.setContentDescription((CharSequence)string);
    }

    @V(a={W.c})
    public void a(c c2) {
        this.d = c2;
    }

    public boolean a() {
        if (this.c() || !this.r) {
            return false;
        }
        this.g = false;
        this.b(this.h);
        return true;
    }

    void b(int n2) {
        int n3;
        if (this.a.e() == null) {
            throw new IllegalStateException("No data model. Did you call #setDataModel?");
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.p);
        boolean bl = this.c.getVisibility() == 0;
        int n4 = this.a.c();
        int n5 = n3 = bl ? 1 : 0;
        if (n2 != Integer.MAX_VALUE && n4 > n2 + n3) {
            this.a.a(true);
            this.a.a(n2 - 1);
        } else {
            this.a.a(false);
            this.a.a(n2);
        }
        aS aS2 = this.e();
        if (!aS2.e()) {
            if (this.g || !bl) {
                this.a.a(true, bl);
            } else {
                this.a.a(false, false);
            }
            int n6 = Math.min(this.a.a(), this.o);
            aS2.i(n6);
            aS2.c_();
            if (this.d != null) {
                this.d.a(true);
            }
            aS2.d_().setContentDescription((CharSequence)this.getContext().getString(androidx.appcompat.l.f));
            aS2.d_().setSelector((Drawable)new ColorDrawable(0));
        }
    }

    public boolean b() {
        if (this.c()) {
            this.e().d();
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeGlobalOnLayoutListener(this.p);
            }
        }
        return true;
    }

    public boolean c() {
        return this.e().e();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        z z2 = this.a.e();
        if (z2 != null) {
            z2.registerObserver(this.e);
        }
        this.r = true;
    }

    protected void onDetachedFromWindow() {
        ViewTreeObserver viewTreeObserver;
        super.onDetachedFromWindow();
        z z2 = this.a.e();
        if (z2 != null) {
            z2.unregisterObserver(this.e);
        }
        if ((viewTreeObserver = this.getViewTreeObserver()).isAlive()) {
            viewTreeObserver.removeGlobalOnLayoutListener(this.p);
        }
        if (this.c()) {
            this.b();
        }
        this.r = false;
    }

    protected void onMeasure(int n2, int n3) {
        View view = this.k;
        if (this.c.getVisibility() != 0) {
            n3 = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)n3), (int)0x40000000);
        }
        this.measureChild(view, n2, n3);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        this.k.layout(0, 0, n4 - n2, n5 - n3);
        if (!this.c()) {
            this.b();
        }
    }

    public z d() {
        return this.a.e();
    }

    public void a(PopupWindow.OnDismissListener onDismissListener) {
        this.f = onDismissListener;
    }

    public void c(int n2) {
        this.h = n2;
    }

    public void d(int n2) {
        this.s = n2;
    }

    aS e() {
        if (this.q == null) {
            this.q = new aS(this.getContext());
            this.q.a((ListAdapter)this.a);
            this.q.b((View)this);
            this.q.a(true);
            this.q.a(this.j);
            this.q.a(this.j);
        }
        return this.q;
    }

    void f() {
        if (this.a.getCount() > 0) {
            this.b.setEnabled(true);
        } else {
            this.b.setEnabled(false);
        }
        int n2 = this.a.c();
        int n3 = this.a.d();
        if (n2 == 1 || n2 > 1 && n3 > 0) {
            this.c.setVisibility(0);
            ResolveInfo resolveInfo = this.a.b();
            PackageManager packageManager = this.getContext().getPackageManager();
            this.n.setImageDrawable(resolveInfo.loadIcon(packageManager));
            if (this.s != 0) {
                CharSequence charSequence = resolveInfo.loadLabel(packageManager);
                String string = this.getContext().getString(this.s, new Object[]{charSequence});
                this.c.setContentDescription((CharSequence)string);
            }
        } else {
            this.c.setVisibility(8);
        }
        if (this.c.getVisibility() == 0) {
            this.k.setBackgroundDrawable(this.l);
        } else {
            this.k.setBackgroundDrawable(null);
        }
    }
}

