/* While this template provides a good starting point for using Wear Compose, you can always
 * take a look at https://github.com/android/wear-os-samples/tree/main/ComposeStarter to find the
 * most up to date changes to the libraries and their usages.
 */

package com.samsung.wearcomposeplayground.presentation

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.drawBehind
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.graphicsLayer
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import androidx.core.splashscreen.SplashScreen.Companion.installSplashScreen
import androidx.wear.compose.foundation.lazy.TransformingLazyColumn
import androidx.wear.compose.material.MaterialTheme
import androidx.wear.compose.material.Text
import androidx.wear.tooling.preview.devices.WearDevices
import com.samsung.wearcomposeplayground.R
import com.samsung.wearcomposeplayground.presentation.theme.WearComposePlaygroundTheme
import kotlin.math.max
import kotlin.math.roundToInt

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        installSplashScreen()

        super.onCreate(savedInstanceState)

        setTheme(android.R.style.Theme_DeviceDefault)

        setContent {
            WearApp("Android")
        }
    }
}

@Composable
fun WearApp(greetingName: String) {
    WearComposePlaygroundTheme {
        TransformingLazyColumnLettersSample()
//        val state = rememberTransformingLazyColumnState()
//        NavHost(
//            navController = rememberNavController(),
//            startDestination = "start"
//        ) {
//            composable("start") {
//                ScreenScaffold(scrollState = state) { padding ->
//                    TransformingLazyColumn(
//                        state = state,
//                        contentPadding = padding
//                    ) {
//                        items(100) { it ->
//                            Text(text="test $it")
//                        }
//                    }
//                }
//            }
//        }
    }
}

@Composable
fun Greeting(greetingName: String) {
    Text(
        modifier = Modifier.fillMaxWidth(),
        textAlign = TextAlign.Center,
        color = MaterialTheme.colors.primary,
        text = stringResource(R.string.hello_world, greetingName)
    )
}

@Preview(device = WearDevices.SMALL_ROUND, showSystemUi = true)
@Composable
fun DefaultPreview() {
    WearApp("Preview Android")
}

@Preview
@Composable
fun TransformingLazyColumnLettersSample() {
    val alphabet = ('A'..'Z').map { it.toString() }

    fun rainbowColor(progress: Float): Color {
        val hue = progress * 360f
        val saturation = 1f
        val value = 1f

        return Color(android.graphics.Color.HSVToColor(floatArrayOf(hue, saturation, value)))
    }

    TransformingLazyColumn {
        items(count = alphabet.size) { index ->
            Text(
                alphabet[index],
                modifier =
                Modifier.transformedHeight { measuredHeight, scrollProgress ->
                    if (scrollProgress.topOffsetFraction < 0f)
                        (measuredHeight * scrollProgress.bottomOffsetFraction /
                                (scrollProgress.bottomOffsetFraction -
                                        scrollProgress.topOffsetFraction))
                            .roundToInt()
                    else measuredHeight
                }
                    .graphicsLayer {
                        with(scrollProgress) {
                            if (isUnspecified) {
                                return@graphicsLayer
                            }
                            rotationY =
                                -180f + (topOffsetFraction + bottomOffsetFraction) * 180f
                            val scale =
                                (bottomOffsetFraction - max(topOffsetFraction, 0f)) /
                                        (bottomOffsetFraction - topOffsetFraction)
                            scaleY = scale
                            translationY = size.height * (scale - 1f) / 2f
                        }
                    }
                    .drawBehind {
                        with(scrollProgress) {
                            if (isUnspecified) {
                                return@drawBehind
                            }
                            val colorProgress = (topOffsetFraction + bottomOffsetFraction) / 2f
                            drawCircle(rainbowColor(colorProgress))
                        }
                    }
                    .padding(20.dp)
            )
        }
    }
}