package com.example.windowinsetstest

import androidx.compose.foundation.BorderStroke
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.safeContentPadding
import androidx.compose.foundation.layout.safeDrawingPadding
import androidx.compose.foundation.layout.statusBarsPadding
import androidx.compose.foundation.layout.systemBarsPadding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.OutlinedCard
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import androidx.compose.ui.window.DialogProperties

@Composable
fun ListDialog() {
    var showDialog by remember {
        mutableStateOf(true)
    }
    if (!showDialog) return
    Dialog(
        onDismissRequest = { showDialog = false },
        properties = DialogProperties(
            usePlatformDefaultWidth = false,
            decorFitsSystemWindows = false
        )
    ) {
        OutlinedCard(
            modifier = Modifier
                .systemBarsPadding()
                .safeDrawingPadding(),
            shape = MaterialTheme.shapes.small,
            border = BorderStroke(
                CardDefaults.outlinedCardBorder().width,
                MaterialTheme.colorScheme.primaryContainer
            )
        ) {
            Text(
                modifier = Modifier
                    .background(MaterialTheme.colorScheme.primaryContainer)
                    .fillMaxWidth()
                    .padding(5.dp),
                text = "List Dialog",
                color = MaterialTheme.colorScheme.onPrimaryContainer,
                textAlign = TextAlign.Center,
                style = MaterialTheme.typography.titleLarge
            )
            LazyColumn(
                modifier = Modifier.weight(1f, false),
                contentPadding = PaddingValues(horizontal = 10.dp, vertical = 5.dp),
                verticalArrangement = Arrangement.spacedBy(5.dp)
            ) {
                items(
                    100,
                    key = {
                        it
                    }
                ) {
                    OutlinedCard {
                        Text(
                            modifier = Modifier
                                .fillMaxWidth()
                                .padding(10.dp),
                            text = "Item $it",
                            style = MaterialTheme.typography.titleLarge
                        )
                    }
                }
            }
            TextButton(
                modifier = Modifier
                    .align(Alignment.End)
                    .padding(end = 5.dp),
                onClick = {
                    showDialog = false
                },
            ) {
                Text(
                    modifier = Modifier.align(Alignment.CenterVertically),
                    text = "Close",
                )
            }
        }
    }
}