@file:OptIn(ExperimentalMaterial3Api::class)

package com.example.windowinsetstest

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.WindowInsetsSides
import androidx.compose.foundation.layout.consumeWindowInsets
import androidx.compose.foundation.layout.displayCutout
import androidx.compose.foundation.layout.exclude
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.imePadding
import androidx.compose.foundation.layout.only
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.systemBars
import androidx.compose.foundation.layout.windowInsetsBottomHeight
import androidx.compose.foundation.layout.windowInsetsPadding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.text.BasicTextField
import androidx.compose.foundation.text.input.rememberTextFieldState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Home
import androidx.compose.material3.BottomAppBar
import androidx.compose.material3.BottomAppBarDefaults
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.ModalDrawerSheet
import androidx.compose.material3.ModalNavigationDrawer
import androidx.compose.material3.NavigationBarItem
import androidx.compose.material3.OutlinedCard
import androidx.compose.material3.Scaffold
import androidx.compose.material3.ScaffoldDefaults
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import androidx.core.splashscreen.SplashScreen.Companion.installSplashScreen
import com.example.windowinsetstest.ui.theme.WindowInsetsTestTheme

class MainActivity : ComponentActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        installSplashScreen()
        enableEdgeToEdge()
        setContent {
            App(
                themeWrapper = {
                    WindowInsetsTestTheme (content = it)
                }
            )
        }
    }
}

@Composable
fun App(
    themeWrapper: @Composable (@Composable () -> Unit) -> Unit = {
        MaterialTheme (
            content = it
        )
    }
) {
    themeWrapper {
        ModalNavigationDrawer(
            drawerContent = {
                ModalDrawerSheet {
                    Box(
                        modifier = Modifier
                            .fillMaxSize(),
                        contentAlignment = Alignment.Center
                    ) {
                        Text("Drawer")
                    }
                }
            },
            modifier = Modifier.fillMaxSize()
        ) {
//            ScaffoldWithAppBarAndTextField()
            Row {
                NestedScaffoldBottomNavigation(
                    modifier = Modifier.weight(1f)
                )
                ScaffoldWithAppBar(
                    modifier = Modifier.weight(1f)
                )
                ScaffoldWithAppBarAndOverScrollList(
                    modifier = Modifier.weight(1f)
                )
            }
        }
    }
}

@Composable
fun NestedScaffoldBottomNavigation(modifier: Modifier = Modifier) {
    Scaffold(
        modifier = modifier
            .fillMaxSize(),
        bottomBar = {
            BottomAppBar(
                containerColor = MaterialTheme.colorScheme.primaryContainer,
            ) {
                NavigationBarItem(
                    selected = true,
                    onClick = {

                    },
                    icon = {
                        Icon(
                            imageVector = Icons.Default.Home,
                            contentDescription = null
                        )
                    },
                    label = {
                        Text("Home")
                    }
                )
            }
        },
        contentWindowInsets = ScaffoldDefaults.contentWindowInsets
            .exclude(TopAppBarDefaults.windowInsets),
    ) { innerPadding ->
        Scaffold(
            modifier = Modifier
                .consumeWindowInsets(BottomAppBarDefaults.windowInsets)
                .padding(innerPadding),
            topBar = {
                TopAppBar(
                    title = {
                        Text(text = "TopAppBar")
                    },
                    colors = TopAppBarDefaults.topAppBarColors().copy(
                        containerColor = MaterialTheme.colorScheme.tertiaryContainer,
                        titleContentColor = MaterialTheme.colorScheme.onTertiaryContainer
                    ),
                )
            }
        ) {
            Box(
                modifier = Modifier
                    .background(Color.Green)
                    .padding(it)
                    .background(Color.Yellow)
                    .fillMaxSize()
            )
        }
    }
}

@Composable
fun ScaffoldWithAppBar(modifier: Modifier = Modifier) {
    Scaffold (
        modifier = modifier,
        topBar = {
            TopAppBar(
                title = {
                    Text(text = "TopAppBar")
                },
                colors = TopAppBarDefaults.topAppBarColors().copy(
                    containerColor = MaterialTheme.colorScheme.tertiaryContainer,
                    titleContentColor = MaterialTheme.colorScheme.onTertiaryContainer
                ),
            )
        }
    ){
        Box(
            modifier = Modifier
                .background(Color.Green)
                .padding(it)
                .background(Color.Yellow)
                .fillMaxSize()
        )
    }
}

@Composable
fun ScaffoldWithAppBarAndOverScrollList(modifier: Modifier = Modifier) {
    Scaffold (
        modifier = modifier,
        topBar = {
            TopAppBar(
                title = {
                    Text(text = "TopAppBar")
                },
                colors = TopAppBarDefaults.topAppBarColors().copy(
                    containerColor = MaterialTheme.colorScheme.tertiaryContainer,
                    titleContentColor = MaterialTheme.colorScheme.onTertiaryContainer
                ),
            )
        },
        contentWindowInsets = ScaffoldDefaults.contentWindowInsets
            .exclude(WindowInsets.systemBars)
    ){
        LazyColumn(
            modifier = Modifier
                .background(Color.Green)
                .padding(it)
                .windowInsetsPadding(
                    insets = WindowInsets.displayCutout.only(
                        WindowInsetsSides.Horizontal
                    )
                )
                .background(Color.Yellow)
                .fillMaxSize(),
        ) {
            (1..30).forEach {
                item {
                    Text(
                        modifier = Modifier.padding(5.dp),
                        text = "Item $it"
                    )
                }
            }
            item {
                Spacer(
                    modifier = Modifier.windowInsetsBottomHeight(
                            WindowInsets.systemBars
                        )
                )
            }
        }
    }
}

@Composable
fun ScaffoldWithAppBarAndTextField(modifier: Modifier = Modifier) {
    Scaffold (
        modifier = modifier,
        topBar = {
            TopAppBar(
                title = {
                    Text(text = "TopAppBar")
                },
                colors = TopAppBarDefaults.topAppBarColors().copy(
                    containerColor = MaterialTheme.colorScheme.tertiaryContainer,
                    titleContentColor = MaterialTheme.colorScheme.onTertiaryContainer
                ),
            )
        },
        contentWindowInsets = ScaffoldDefaults.contentWindowInsets
            .exclude(WindowInsets.systemBars)
    ){
        Box(
            modifier = Modifier
                .padding(it)
                .imePadding()
                .fillMaxSize()
                .verticalScroll(rememberScrollState()),
            contentAlignment = Alignment.Center
        ){
            OutlinedCard(
                modifier = Modifier.padding(10.dp)
            ) {
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
                BasicTextField(
                    modifier = Modifier
                        .fillMaxWidth()
                        .padding(10.dp),
                    state = rememberTextFieldState(),
                    decorator = { innerTextField ->
                        OutlinedCard (
                            shape = MaterialTheme.shapes.small
                        ){
                            Box (
                                modifier = Modifier.padding(10.dp)
                            ){
                                innerTextField()
                            }
                        }
                    }
                )
            }
        }
    }
}

