package com.example.windowinsetstest.navigation

import com.example.windowinsetstest.screens.DestinationsDestination
import com.example.windowinsetstest.screens.DestinationsEvent
import com.example.windowinsetstest.ui.navigation.ComposeNavigation
import com.example.windowinsetstest.ui.navigation.DestinationComposable
import com.example.windowinsetstest.ui.navigation.NavigationComponent
import com.example.windowinsetstest.ui.navigation.NavigationDestination
import com.example.windowinsetstest.ui.navigation.NavigationGraph

class MainNavigation(
    private val toLogin: () -> Unit
): ComposeNavigation<NavigationComponent<*>,Unit>() {
    override val startDestination: NavigationDestination<*>
        get() = DestinationsDestination
    override val composables: List<DestinationComposable<*, *, Unit>>
        get() = listOf(
            DestinationComposable(
                destinationClass = DestinationsDestination::class,
                serializer = DestinationsDestination.serializer(),
                eventHandler = { component, event, onNavigationEvent, onEvent ->
                    when(event){
                        DestinationsEvent.ToLogin -> toLogin()
                        DestinationsEvent.ToNestedScaffoldWithBottomNavigation -> TODO()
                        DestinationsEvent.ToScaffoldAppBar -> TODO()
                        DestinationsEvent.ToScaffoldList -> TODO()
                        DestinationsEvent.ToScaffoldTextField -> TODO()
                    }
                }
            )
        )
}