package com.example.windowinsetstest.screens

import androidx.compose.animation.AnimatedContentScope
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.IntrinsicSize
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.width
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.navigation.NavBackStackEntry
import com.example.windowinsetstest.ui.navigation.NavigationDestination
import kotlinx.serialization.Serializable

@Serializable
object DestinationsDestination: NavigationDestination<DestinationsEvent> {
    @Composable
    override fun AnimatedContentScope.Content(entry: NavBackStackEntry, onEvent: (DestinationsEvent) -> Unit) {
        Box(
            modifier = Modifier.fillMaxSize(),
            contentAlignment = Alignment.Center
        ) {
            Column(
                modifier = Modifier
                    .width(IntrinsicSize.Max)
            ) {
                Button(
                    modifier = Modifier.fillMaxSize(),
                    onClick = {
                        onEvent(DestinationsEvent.ToNestedScaffoldWithBottomNavigation)
                    }
                ) {
                    Text("ToNestedScaffoldWithBottomNavigation")
                }
                Button(
                    modifier = Modifier.fillMaxSize(),
                    onClick = {
                        onEvent(DestinationsEvent.ToScaffoldAppBar)
                    }
                ) {
                    Text("ToScaffoldAppBar")
                }
                Button(
                    modifier = Modifier.fillMaxSize(),
                    onClick = {
                        onEvent(DestinationsEvent.ToScaffoldList)
                    }
                ) {
                    Text("ToScaffoldList")
                }
                Button(
                    modifier = Modifier.fillMaxSize(),
                    onClick = {
                        onEvent(DestinationsEvent.ToScaffoldTextField)
                    }
                ) {
                    Text("ToScaffoldTextField")
                }
                Button(
                    modifier = Modifier.fillMaxSize(),
                    onClick = {
                        onEvent(DestinationsEvent.ToLogin)
                    }
                ) {
                    Text("ToLogin")
                }
            }
        }
    }
}