package com.example.windowinsetstest.screens

import androidx.compose.animation.AnimatedContentScope
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.ModalDrawerSheet
import androidx.compose.material3.ModalNavigationDrawer
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.navigation.NavBackStackEntry
import com.example.windowinsetstest.ui.navigation.NavigationDestination
import kotlinx.serialization.Serializable

@Serializable
object MainDestination: NavigationDestination<DestinationsEvent> {
    @Composable
    override fun AnimatedContentScope.Content(entry: NavBackStackEntry, onEvent: (DestinationsEvent) -> Unit) {
        ModalNavigationDrawer(
            drawerContent = {
                ModalDrawerSheet {
                    Box(
                        modifier = Modifier
                            .fillMaxSize(),
                        contentAlignment = Alignment.Center
                    ) {
                        Text("Drawer")
                    }
                }
            },
            modifier = Modifier.fillMaxSize()
        ) {

        }
    }
}