package com.example.windowinsetstest.screens

import androidx.compose.animation.AnimatedContentScope
import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.WindowInsetsSides
import androidx.compose.foundation.layout.displayCutout
import androidx.compose.foundation.layout.exclude
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.only
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.systemBars
import androidx.compose.foundation.layout.windowInsetsBottomHeight
import androidx.compose.foundation.layout.windowInsetsPadding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.KeyboardArrowLeft
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Scaffold
import androidx.compose.material3.ScaffoldDefaults
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import androidx.navigation.NavBackStackEntry
import com.example.windowinsetstest.screens.ScaffoldWithAppBarDestination.invoke
import com.example.windowinsetstest.ui.navigation.NavigationDestination
import kotlinx.serialization.Serializable

@Serializable
object ScaffoldListDestination: NavigationDestination<Unit> {
    @OptIn(ExperimentalMaterial3Api::class)
    @Composable
    override fun AnimatedContentScope.Content(entry: NavBackStackEntry, onEvent: (Unit) -> Unit) {
        Scaffold (
            topBar = {
                TopAppBar(
                    title = {
                        Text(text = "TopAppBar")
                    },
                    navigationIcon = {
                        IconButton(
                            onClick = { onEvent() }
                        ) {
                            Icon(
                                imageVector = Icons.AutoMirrored.Filled.KeyboardArrowLeft,
                                contentDescription = null
                            )
                        }
                    },
                    colors = TopAppBarDefaults.topAppBarColors().copy(
                        containerColor = MaterialTheme.colorScheme.tertiaryContainer,
                        titleContentColor = MaterialTheme.colorScheme.onTertiaryContainer
                    ),
                )
            },
            contentWindowInsets = ScaffoldDefaults.contentWindowInsets
                .exclude(WindowInsets.systemBars)
        ){
            LazyColumn(
                modifier = Modifier
                    .background(Color.Green)
                    .padding(it)
                    .windowInsetsPadding(
                        insets = WindowInsets.displayCutout.only(
                            WindowInsetsSides.Horizontal
                        )
                    )
                    .background(Color.Yellow)
                    .fillMaxSize(),
            ) {
                (1..30).forEach {
                    item {
                        Text(
                            modifier = Modifier.padding(5.dp),
                            text = "Item $it"
                        )
                    }
                }
                item {
                    Spacer(
                        modifier = Modifier.windowInsetsBottomHeight(
                            WindowInsets.systemBars
                        )
                    )
                }
            }
        }
    }
}