package com.example.windowinsetstest.screens

import androidx.compose.animation.AnimatedContentScope
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.WindowInsets
import androidx.compose.foundation.layout.exclude
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.imePadding
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.systemBars
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.text.BasicTextField
import androidx.compose.foundation.text.input.rememberTextFieldState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.KeyboardArrowLeft
import androidx.compose.material3.Button
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.OutlinedCard
import androidx.compose.material3.Scaffold
import androidx.compose.material3.ScaffoldDefaults
import androidx.compose.material3.Text
import androidx.compose.material3.TopAppBar
import androidx.compose.material3.TopAppBarDefaults
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.unit.dp
import androidx.navigation.NavBackStackEntry
import com.example.windowinsetstest.screens.ScaffoldListDestination.invoke
import com.example.windowinsetstest.ui.navigation.NavigationDestination
import kotlinx.serialization.Serializable

@Serializable
object ScaffoldTextFieldDestination: NavigationDestination<Unit> {
    @OptIn(ExperimentalMaterial3Api::class)
    @Composable
    override fun AnimatedContentScope.Content(entry: NavBackStackEntry, onEvent: (Unit) -> Unit) {
        Scaffold (
            topBar = {
                TopAppBar(
                    title = {
                        Text(text = "TopAppBar")
                    },
                    navigationIcon = {
                        IconButton(
                            onClick = { onEvent() }
                        ) {
                            Icon(
                                imageVector = Icons.AutoMirrored.Filled.KeyboardArrowLeft,
                                contentDescription = null
                            )
                        }
                    },
                    colors = TopAppBarDefaults.topAppBarColors().copy(
                        containerColor = MaterialTheme.colorScheme.tertiaryContainer,
                        titleContentColor = MaterialTheme.colorScheme.onTertiaryContainer
                    ),
                )
            },
            contentWindowInsets = ScaffoldDefaults.contentWindowInsets
                .exclude(WindowInsets.systemBars)
        ){
            Box(
                modifier = Modifier
                    .padding(it)
                    .imePadding()
                    .fillMaxSize()
                    .verticalScroll(rememberScrollState()),
                contentAlignment = Alignment.Center
            ){
                OutlinedCard(
                    modifier = Modifier.padding(10.dp)
                ) {
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                    BasicTextField(
                        modifier = Modifier
                            .fillMaxWidth()
                            .padding(10.dp),
                        state = rememberTextFieldState(),
                        decorator = { innerTextField ->
                            OutlinedCard (
                                shape = MaterialTheme.shapes.small
                            ){
                                Box (
                                    modifier = Modifier.padding(10.dp)
                                ){
                                    innerTextField()
                                }
                            }
                        }
                    )
                }
            }
        }
    }
}