package com.example.windowinsetstest.ui.navigation

import android.annotation.SuppressLint
import androidx.navigation.NavGraphBuilder
import androidx.navigation.compose.navigation

data class GraphComposable<E, G: NavigationGraph<E>, NavEvent>(
    override val component: G,
    override val eventHandler: ComponentEventHandler<E, G, NavEvent> = ComponentEventHandler { graph, event, _, _ ->
        error(
            buildString {
                append("Unhandled Graph: ")
                append(graph)
                appendLine()
                append("Event: ")
                append(event)
            }
        )
    }
): NavigationComposable.Object<E, G, NavEvent> {

    @SuppressLint("RestrictedApi")
    fun NavGraphBuilder.setGraph(
        onNavigationEvent: (NavigationEvent) -> Unit,
        onEvent: (NavEvent) -> Unit
    ){
        navigation(
            startDestination = component.startDestination,
            route = component::class
        ){
            component.composables.forEach { destinationComposable ->
                destinationComposable.run {
                    composable(
                        onNavigationEvent = onNavigationEvent,
                        onGraphEvent = {
                            eventHandler(
                                component = component,
                                event = it,
                                onNavigationEvent = onNavigationEvent,
                                onEvent = onEvent
                            )
                        }
                    )
                }
            }
        }
    }
}
