package com.example.tutorial

import android.os.Bundle
import androidx.activity.ComponentActivity
import androidx.activity.compose.setContent
import androidx.activity.enableEdgeToEdge
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.material3.Button
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.saveable.rememberSaveableStateHolder
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier

class MainActivity : ComponentActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        enableEdgeToEdge()

        setContent {
            Surface {
                RootContent()
            }
        }
    }
}

@Composable
fun RootContent() {
    var screen by remember { mutableStateOf<Screen>(Screen.First) }

    Foo(screen = screen) {
        Surface(modifier = Modifier.fillMaxSize()) {
            when (it) {
                Screen.First -> Screen(text = "Go forward", onClick = { screen = Screen.Second })
                Screen.Second -> Screen(text = "Go back", onClick = { screen = Screen.First })
            }
        }
    }
}

sealed interface Screen {
    val key: String

    data object First : Screen {
        override val key: String = "first"
    }

    data object Second : Screen {
        override val key: String = "second"
    }
}

@Composable
fun Foo(screen: Screen, content: @Composable (Screen) -> Unit) {
    val holder = rememberSaveableStateHolder()
    holder.SaveableStateProvider(key = screen.key) {
        content(screen)
    }
}

@Composable
fun Screen(text: String, onClick: () -> Unit) {
    Box(
        modifier = Modifier.fillMaxSize(),
        contentAlignment = Alignment.Center
    ) {
        Button(onClick = onClick) {
            Text(text = text)
        }
    }
}
