package org.jdc.sample.datasource.database.converter

import android.arch.persistence.room.TypeConverter
import java.util.Date

class DateLongConverter {
    @TypeConverter
    fun fromLongToDate(value: Long?): Date? {
        value ?: return null

        return Date().apply {
            time = value
        }
    }

    @TypeConverter
    fun fromDateToLong(value: Date?) = value?.time
}