package org.jdc.sample.datasource.database.main

import android.arch.persistence.room.Database
import android.arch.persistence.room.RoomDatabase
import android.arch.persistence.room.TypeConverters
import org.jdc.sample.datasource.database.main.converter.MainDatabaseConverters
import org.jdc.sample.datasource.database.main.household.Household
import org.jdc.sample.datasource.database.main.household.HouseholdDao
import org.jdc.sample.datasource.database.main.individual.Individual
import org.jdc.sample.datasource.database.main.individual.IndividualDao

@Database(entities = arrayOf(
        Individual::class,
        Household::class),
        version = 1)
@TypeConverters(MainDatabaseConverters::class)
abstract class MainDatabase : RoomDatabase() {

    abstract fun individualDao(): IndividualDao
    abstract fun householdDao(): HouseholdDao

    companion object {
        const val DATABASE_NAME = "main"
    }
}