package org.jdc.sample.datasource.database.main.individual

import android.arch.persistence.room.Entity
import android.arch.persistence.room.PrimaryKey
import android.arch.persistence.room.TypeConverters
import org.jdc.sample.datasource.database.converter.DateLongConverter
import org.jdc.sample.datasource.database.main.type.IndividualType
import java.util.Date

@Entity(tableName = "individual")
class Individual constructor() {
    @PrimaryKey(autoGenerate = true)
    var id: Long = 0
    @TypeConverters(DateLongConverter::class)
    var lastModified: Date = Date()
    var householdId: Long = 0
    var individualType: IndividualType = IndividualType.HEAD
    var firstName: String = ""
    var lastName: String = ""
    var phone: String = ""
    var email: String = ""
    var available: Boolean = false

    fun getFullName() = "$firstName $lastName"
}
