package org.jdc.sample.inject

import android.app.Application
import android.arch.persistence.room.Room
import dagger.Module
import dagger.Provides
import org.jdc.sample.datasource.database.main.MainDatabase
import org.jdc.sample.datasource.database.main.household.HouseholdDao
import org.jdc.sample.datasource.database.main.individual.IndividualDao
import javax.inject.Singleton

@Module
class AppModule(private val application: Application) {

    @Provides
    @Singleton
    internal fun provideApplication(): Application {
        return application
    }

    @Provides
    @Singleton
    fun provideMainDatabase(application: Application): MainDatabase {
        return Room.databaseBuilder(application, MainDatabase::class.java, MainDatabase.DATABASE_NAME)
//                .addMigrations(object: Migration(1, 2) {
//                    override fun migrate(p0: SupportSQLiteDatabase?) {
//                    }
//                })
                .build()
    }

    @Provides
    @Singleton
    fun provideIndividualDao(mainDatabase: MainDatabase): IndividualDao {
        return mainDatabase.individualDao()
    }

    @Provides
    @Singleton
    fun provideHouseholdDao(mainDatabase: MainDatabase): HouseholdDao {
        return mainDatabase.householdDao()
    }
}
