package org.jdc.sample.util

import kotlinx.coroutines.experimental.CommonPool
import kotlinx.coroutines.experimental.android.UI
import kotlinx.coroutines.experimental.newFixedThreadPoolContext
import kotlin.coroutines.experimental.CoroutineContext

interface CoroutineContextProvider {
    val ui: CoroutineContext
    val network: CoroutineContext
    val commonPool: CoroutineContext

    object MainCoroutineContextProvider : CoroutineContextProvider {
        override val ui: CoroutineContext
            get() = UI
        override val network: CoroutineContext
            get() = newFixedThreadPoolContext(2, "network-context")
        override val commonPool: CoroutineContext
            get() = CommonPool

    }

    object TestCoroutineContextProvider : CoroutineContextProvider {
        override val ui: CoroutineContext
            get() = CommonPool
        override val network: CoroutineContext
            get() = CommonPool
        override val commonPool: CoroutineContext
            get() = CommonPool

    }
}

