// Generated by dagger.internal.codegen.ComponentProcessor (https://google.github.io/dagger).
package com.sample.sample.components;

import android.content.Context;
import com.sample.sample.activity.MainActivity;
import com.sample.sample.fragments.DashboardFragment;
import com.sample.sample.fragments.DashboardFragment_MembersInjector;
import com.sample.sample.interfaces.SampleAppService;
import com.sample.sample.modules.AppModule;
import com.sample.sample.modules.AppModule_ProvidesApplicationContextFactory;
import com.sample.sample.modules.AppModule_ProvidesOkHttpCacheFactory;
import com.sample.sample.modules.AppModule_ProvidesOkHttpClientFactory;
import com.sample.sample.modules.SampleAppModule;
import com.sample.sample.modules.SampleAppModule_ProvidesTMIServiceFactory;
import com.sample.sample.modules.SampleAppModule_ProvidesTmiRepositoryFactory;
import com.sample.sample.modules.SampleAppModule_ProvidesTmiViewModelFactoryFactory;
import com.sample.sample.repository.SampleAppRepository;
import com.sample.sample.viewmodel.factory.ViewModelFactory;
import dagger.MembersInjector;
import dagger.internal.DoubleCheck;
import dagger.internal.MembersInjectors;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import okhttp3.Cache;
import okhttp3.OkHttpClient;

public final class DaggerSampleAppComponent implements SampleAppComponent {
  private Provider<Context> providesApplicationContextProvider;

  private Provider<Cache> providesOkHttpCacheProvider;

  private Provider<OkHttpClient> providesOkHttpClientProvider;

  private Provider<SampleAppService> providesTMIServiceProvider;

  private Provider<SampleAppRepository> providesTmiRepositoryProvider;

  private Provider<ViewModelFactory> providesTmiViewModelFactoryProvider;

  private MembersInjector<DashboardFragment> dashboardFragmentMembersInjector;

  private DaggerSampleAppComponent(Builder builder) {
    assert builder != null;
    initialize(builder);
  }

  public static Builder builder() {
    return new Builder();
  }

  @SuppressWarnings("unchecked")
  private void initialize(final Builder builder) {

    this.providesApplicationContextProvider =
        DoubleCheck.provider(AppModule_ProvidesApplicationContextFactory.create(builder.appModule));

    this.providesOkHttpCacheProvider =
        DoubleCheck.provider(
            AppModule_ProvidesOkHttpCacheFactory.create(
                builder.appModule, providesApplicationContextProvider));

    this.providesOkHttpClientProvider =
        DoubleCheck.provider(
            AppModule_ProvidesOkHttpClientFactory.create(
                builder.appModule, providesOkHttpCacheProvider));

    this.providesTMIServiceProvider =
        DoubleCheck.provider(
            SampleAppModule_ProvidesTMIServiceFactory.create(
                builder.sampleAppModule,
                providesOkHttpClientProvider,
                providesApplicationContextProvider));

    this.providesTmiRepositoryProvider =
        DoubleCheck.provider(
            SampleAppModule_ProvidesTmiRepositoryFactory.create(
                builder.sampleAppModule, providesTMIServiceProvider));

    this.providesTmiViewModelFactoryProvider =
        DoubleCheck.provider(
            SampleAppModule_ProvidesTmiViewModelFactoryFactory.create(
                builder.sampleAppModule, providesTmiRepositoryProvider));

    this.dashboardFragmentMembersInjector =
        DashboardFragment_MembersInjector.create(providesTmiViewModelFactoryProvider);
  }

  @Override
  public void inject(DashboardFragment dashboardFragment) {
    dashboardFragmentMembersInjector.injectMembers(dashboardFragment);
  }

  @Override
  public void inject(MainActivity mainActivity) {
    MembersInjectors.<MainActivity>noOp().injectMembers(mainActivity);
  }

  public static final class Builder {
    private AppModule appModule;

    private SampleAppModule sampleAppModule;

    private Builder() {}

    public SampleAppComponent build() {
      if (appModule == null) {
        throw new IllegalStateException(AppModule.class.getCanonicalName() + " must be set");
      }
      if (sampleAppModule == null) {
        this.sampleAppModule = new SampleAppModule();
      }
      return new DaggerSampleAppComponent(this);
    }

    public Builder appModule(AppModule appModule) {
      this.appModule = Preconditions.checkNotNull(appModule);
      return this;
    }

    public Builder sampleAppModule(SampleAppModule sampleAppModule) {
      this.sampleAppModule = Preconditions.checkNotNull(sampleAppModule);
      return this;
    }
  }
}
