package com.sample.sample.fragments;

import android.arch.lifecycle.ViewModelProviders;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import com.sample.sample.R;
import com.sample.sample.SampleApplication;
import com.sample.sample.viewmodel.ViewModel;
import com.sample.sample.viewmodel.factory.ViewModelFactory;

import javax.inject.Inject;


public class DashboardFragment extends Fragment
{
	@Inject
	ViewModelFactory viewModelFactory;

	private ViewModel viewModel;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
							 Bundle savedInstanceState)
	{
		View view = inflater.inflate(R.layout.fragment_dashboard, container, false);

		((SampleApplication) getActivity().getApplication()).getAppComponent().inject(this);

		return view;
	}

	@Override
	public void onViewCreated(View view, @Nullable Bundle savedInstanceState)
	{
	}

	@Override
	public void onActivityCreated(Bundle savedInstanceSTate)
	{
		super.onActivityCreated(savedInstanceSTate);

		setUpTmiModel();
	}

	private void setUpTmiModel()
	{
		viewModel = ViewModelProviders.of(this, viewModelFactory).get(ViewModel.class);
	}
}
