package com.sample.sample.modules;

import android.content.Context;

import com.sample.sample.utils.SampleAppConstants;

import java.util.concurrent.TimeUnit;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import okhttp3.Cache;
import okhttp3.OkHttpClient;

@Module
public class AppModule
{
	private Context context;

	public AppModule(Context context)
	{
		this.context = context;
	}

	@Provides
	@Singleton
	Context providesApplicationContext()
	{
		return context;
	}

	@Provides
	@Singleton
	Cache providesOkHttpCache(Context context)
	{
		int cacheSize = 10 * 1024 * 1024; // 10 MiB
		return new Cache(context.getCacheDir(), cacheSize);
	}

	@Provides
	@Singleton
	OkHttpClient providesOkHttpClient(Cache cache)
	{
		return new OkHttpClient.Builder()
				.cache(cache)
				.readTimeout(SampleAppConstants.TIMEOUT_READ_IN_SECONDS, TimeUnit.SECONDS)
				.connectTimeout(SampleAppConstants.TIMEOUT_CONNECT_IN_SECONDS, TimeUnit.SECONDS)
				.build();
	}
}
