package com.sample.sample.modules;

import android.content.Context;

import com.sample.sample.interfaces.SampleAppService;
import com.sample.sample.repository.SampleAppRepository;
import com.sample.sample.viewmodel.factory.ViewModelFactory;

import javax.inject.Singleton;

import dagger.Module;
import dagger.Provides;
import okhttp3.OkHttpClient;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

@Module
public class SampleAppModule
{
	@Provides
	@Singleton
	SampleAppService providesTMIService(OkHttpClient okHttpClient, Context context)
	{
		return new Retrofit.Builder()
				.baseUrl("http://google.com/")
				.addConverterFactory(GsonConverterFactory.create())
				.addCallAdapterFactory(RxJava2CallAdapterFactory.create())
				.client(okHttpClient)
				.build()
				.create(SampleAppService.class);
	}

	@Provides
	@Singleton
	ViewModelFactory providesTmiViewModelFactory(SampleAppRepository sampleAppRepository)
	{
		return new ViewModelFactory(sampleAppRepository);
	}

	@Provides
	@Singleton
	SampleAppRepository providesTmiRepository(SampleAppService sampleAppService)
	{
		return new SampleAppRepository(sampleAppService);
	}
}