package com.example.hunghd.test;

import android.arch.lifecycle.LifecycleRegistry;
import android.arch.lifecycle.LifecycleRegistryOwner;
import android.arch.lifecycle.ViewModelProviders;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;

import com.example.hunghd.test.model.Repository;
import com.example.hunghd.test.viewmodel.RepositoryViewModel;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;

public class MainActivity extends AppCompatActivity implements LifecycleRegistryOwner {

    @BindView(R.id.progress_bar)
    ProgressBar progressBar;
    @BindView(R.id.list_view)
    ListView listView;

    LifecycleRegistry lifecycleRegistry = new LifecycleRegistry(this);

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setContentView(R.layout.activity_main);

        ButterKnife.bind(this);

        RepositoryViewModel viewModel = ViewModelProviders.of(this).get(RepositoryViewModel.class);
        viewModel.getRepositories().observe(this, repositories -> {
            if (repositories.size() > 0) {
                progressBar.setVisibility(View.GONE);
                List<String> reposNames = new ArrayList<>();
                for (Repository repos : repositories) {
                    reposNames.add(repos.getName());
                }
                listView.setAdapter(new ArrayAdapter<String>(MainActivity.this, android.R.layout.simple_list_item_1, reposNames));
            }
        });
    }


    @Override
    public LifecycleRegistry getLifecycle() {
        return lifecycleRegistry;
    }
}
