package com.example.hunghd.test.db;

import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Dao;
import android.arch.persistence.room.Insert;
import android.arch.persistence.room.OnConflictStrategy;
import android.arch.persistence.room.Query;

import com.example.hunghd.test.model.Repository;

import java.util.List;

/**
 * Created by hunghd on 6/6/17.
 */
@Dao
public interface RepositoryDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insert(Repository... items);

    @Query("DELETE FROM repository")
    void deleteAll();

    @Query("SELECT * FROM repository")
    LiveData<List<Repository>> loadRepositories();

}
