package com.example.hunghd.test.services;

import android.app.IntentService;
import android.arch.persistence.room.Room;
import android.content.Intent;
import android.support.annotation.Nullable;

import com.example.hunghd.test.ApplicationController;
import com.example.hunghd.test.api.AppApi;
import com.example.hunghd.test.db.AppDatabase;
import com.example.hunghd.test.model.GithubResponse;
import com.example.hunghd.test.model.Repository;
import com.facebook.stetho.okhttp3.StethoInterceptor;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

/**
 * Created by hunghd on 6/6/17.
 */

public class SearchRepositoryService extends IntentService {

    Retrofit retrofit;
    AppDatabase database;

    public SearchRepositoryService() {
        super("SearchRepositoryService");
    }

    @Override
    public void onCreate() {
        super.onCreate();

        OkHttpClient client = new OkHttpClient.Builder()
                .addNetworkInterceptor(new StethoInterceptor())
                .readTimeout(60, TimeUnit.SECONDS)
                .connectTimeout(60, TimeUnit.SECONDS)
                .build();
        retrofit = new Retrofit.Builder().baseUrl("https://api.github.com/")
                .client(client)
                .addConverterFactory(GsonConverterFactory.create())
                .build();

//        database = ((ApplicationController) getApplication()).getDatabase();
        database = Room.databaseBuilder(this, AppDatabase.class, "app.db").build();
    }

    @Override
    protected void onHandleIntent(@Nullable Intent intent) {
        if (intent != null) {
            try {
                Response<GithubResponse> response = retrofit.create(AppApi.class)
                        .searchRepository("google", 10)
                        .execute();
                if (response.isSuccessful()) {
                    List<Repository> data = response.body().getItems();
                    database.beginTransaction();
                    try {
                        database.repositoryDao().deleteAll();
                        for (Repository repos : data)
                            database.repositoryDao().insert(repos);
                        database.setTransactionSuccessful();
                    } finally {
                        database.endTransaction();
                    }
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}
