package com.example.hunghd.test.viewmodel;

import android.app.Application;
import android.arch.lifecycle.AndroidViewModel;
import android.arch.lifecycle.LiveData;
import android.arch.persistence.room.Room;
import android.content.Intent;

import com.example.hunghd.test.ApplicationController;
import com.example.hunghd.test.db.AppDatabase;
import com.example.hunghd.test.model.Repository;
import com.example.hunghd.test.services.SearchRepositoryService;

import java.util.List;

/**
 * Created by hunghd on 6/6/17.
 */

public class RepositoryViewModel extends AndroidViewModel {

    LiveData<List<Repository>> repositories;

    public RepositoryViewModel(Application application) {
        super(application);
//        AppDatabase database = ((ApplicationController) getApplication()).getDatabase();
        AppDatabase database = Room.databaseBuilder(application, AppDatabase.class, "app.db").build();
        repositories = database.repositoryDao().loadRepositories();

        fetchData();
    }

    public LiveData<List<Repository>> getRepositories() {
        return repositories;
    }

    private void fetchData() {
        Intent intent = new Intent(this.getApplication(), SearchRepositoryService.class);
        getApplication().startService(intent);
    }

    @Override
    protected void onCleared() {
        super.onCleared();
        Intent intent = new Intent(this.getApplication(), SearchRepositoryService.class);
        getApplication().stopService(intent);
    }
}
