package com.sensorberg.archbugreport;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;
import android.util.Log;

import java.util.List;

public class BackgroundDataObserver implements Observer<List<FooData>> {

  public BackgroundDataObserver(LiveData<List<FooData>> liveData) {
    liveData.observeForever(this);
  }

  @Override public void onChanged(@Nullable List<FooData> list) {
    Log.d("archbugreport", "BackgroundDataObserver.onChanged :" + (list == null ? "null" : list.toString()));
  }
}
