package com.sensorberg.archbugreport;

import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.Observer;
import android.support.annotation.Nullable;
import android.util.Log;

import java.util.ArrayList;
import java.util.List;

public class BackgroundDataProcessing<T> extends LiveData<List<T>> {

  private List<T> currentValue = new ArrayList<>();

  void attach(LiveData<T> source) {
    source.observeForever(new OnsObserver(source));
  }

  private class OnsObserver implements Observer<T> {

    private final LiveData<T> source;

    private OnsObserver(LiveData<T> source) {
      this.source = source;
    }

    @Override public void onChanged(@Nullable T value) {
      if (value != null) {

        Log.d("archbugreport", "BackgroundDataProcessing.onChanged :" + value.toString());

        currentValue.add(value);
        setValue(currentValue);
        source.removeObserver(this);

      }
    }
  }
}