package com.sensorberg.archbugreport;

import android.arch.lifecycle.LifecycleActivity;
import android.arch.lifecycle.Observer;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.util.Log;

public class MainActivity extends LifecycleActivity implements Observer<FooData> {

  private final Handler handler = new Handler();

  @Override
  protected void onCreate(Bundle savedInstanceState) {
    super.onCreate(savedInstanceState);
    setContentView(R.layout.activity_main);


    int value = getIntent().getIntExtra("value", 0);
    LiveFoo.queryFoo(value).observe(this, this);

    handler.postDelayed(newActivity, 3000);

  }

  @Override protected void onPause() {
    handler.removeCallbacks(newActivity);
    super.onPause();
  }

  private final Runnable newActivity = new Runnable() {
    @Override public void run() {
      Intent i = new Intent(MainActivity.this, MainActivity.class);
      i.putExtra("value", getIntent().getIntExtra("value", 0) + 1);
      startActivity(i);
    }
  };

  @Override public void onChanged(@Nullable FooData fooData) {
    Log.d("archbugreport", "MainActivity.onChanged :" + (fooData == null ? "null" : fooData.toString()));
  }
}
