package com.test.testapplication;

public class FavoriteBean {

    private int serialNumber;

    private String serialNumberString = "";

    private String title = "";

    private String category = "";

    private String users = "";

    private String description = "";

    public int getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
        this.serialNumberString = String.valueOf(serialNumber);
    }

    public String getSerialNumberString() {
        return serialNumberString;
    }

    public void setSerialNumberString(String serialNumberString) {
        this.serialNumberString = serialNumberString;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getUsers() {
        return users;
    }

    public void setUsers(String users) {
        this.users = users;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public static final class Builder {
        private int serialNumber;
        private String serialNumberString = "";
        private String title = "";
        private String category = "";
        private String users = "";
        private String description = "";

        private Builder() {
        }

        public static Builder aFavoriteBean() {
            return new Builder();
        }

        public Builder withSerialNumber(int serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder withSerialNumberString(String serialNumberString) {
            this.serialNumberString = serialNumberString;
            return this;
        }

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withUsers(String users) {
            this.users = users;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public FavoriteBean build() {
            FavoriteBean favoriteBean = new FavoriteBean();
            favoriteBean.setSerialNumber(serialNumber);
            favoriteBean.setSerialNumberString(serialNumberString);
            favoriteBean.setTitle(title);
            favoriteBean.setCategory(category);
            favoriteBean.setUsers(users);
            favoriteBean.setDescription(description);
            return favoriteBean;
        }
    }
}
