package com.test.testapplication;

import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import timber.log.Timber;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends AppCompatActivity {

//    AdView adView = null;

//    FrameLayout frameLayout;
    SwipeRefreshLayout swipeRefreshLayout;
    RecyclerView recyclerView;

    LinearLayoutManager mLinearLayoutManager;
    NameRecyclerAdapter mAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

//        frameLayout = (FrameLayout) findViewById(R.id.appender);
        swipeRefreshLayout = (SwipeRefreshLayout) findViewById(R.id.pullToRefresh);
        recyclerView = (RecyclerView) findViewById(R.id.recyclerView);

        swipeRefreshLayout.setEnabled(false);

//        initAdMob();
//        adView = createAdView(R.string.banner_ad_unit_id);
//        frameLayout.addView( adView );

        List<FavoriteBean> favoriteBeans = new ArrayList<>();

        for( int i = 1; i <= 1000; i++ ){
            favoriteBeans.add( FavoriteBean.Builder.aFavoriteBean()
                .withTitle("Title " + i)
                .withCategory("Category " + i)
                .withUsers( i + "+")
                .withDescription("This is a Description " + i)
                .withSerialNumber(i)
                .build()
            );
        }

        mLinearLayoutManager = new LinearLayoutManager(this);
        mLinearLayoutManager.setOrientation(LinearLayoutManager.VERTICAL);

        mAdapter = new NameRecyclerAdapter(favoriteBeans, new NameRecyclerAdapter.ItemHolder.IClickHandler() {
            @Override
            public void onClick(View caller, int position) {
                Timber.d("Position " + position);
            }
        });

        recyclerView.setLayoutManager(mLinearLayoutManager);
        mAdapter.setHasStableIds(true);
        recyclerView.setAdapter(mAdapter);
        recyclerView.setItemAnimator( null );
        recyclerView.setHasFixedSize(true);

        mAdapter.notifyDataSetChanged();
    }

//    void initAdMob(){
//        MobileAds.initialize(getApplicationContext(),
//                getResources().getString(R.string.admob_app_id));
//    }
//
//    AdView createAdView(@StringRes int adUnitId){
//        AdView adView = new AdView(getApplicationContext());
//        adView.setAdSize( AdSize.SMART_BANNER );
//        adView.setAdUnitId( getResources().getString(adUnitId) );
//
//        adView.setId( View.generateViewId() );
//
//        loadAd(adView);
//
//        return adView;
//    }
//
//    void loadAd(final AdView adView){
//        adView.loadAd( getBannerAdRequest() );
//    }
//
//    private AdRequest getBannerAdRequest(){
//        return new AdRequest.Builder()
//                .addTestDevice( getResources().getString(R.string.m7_ad_test_device_id) )
//                .build();
//    }
}
