package com.genimee.android.utils.threads

import java.util.concurrent.RejectedExecutionException
import java.util.concurrent.RejectedExecutionHandler
import java.util.concurrent.ThreadPoolExecutor

class ForceQueuePolicy : RejectedExecutionHandler {
    override fun rejectedExecution(runnable: Runnable, executor: ThreadPoolExecutor) {
        try {
            executor.queue.put(runnable)
        } catch (e: InterruptedException) {
            //should never happen since we never wait
            throw RejectedExecutionException(e)
        }
    }
}
