package com.genimee.android.utils.threads

import java.util.concurrent.ThreadFactory
import java.util.concurrent.atomic.AtomicInteger

/**
 * A thread factory that names each thread with the provided threadGroup name.
 */
class GroupNameThreadFactory(groupName: String) : ThreadFactory {
    private val threadGroup: ThreadGroup = Thread.currentThread().threadGroup
    private val threadNumber = AtomicInteger(1)
    private val namePrefix: String

    init {
        namePrefix = groupName + "-" + POOL_NUMBER.getAndIncrement() + "-t-"
    }

    override fun newThread(runnable: Runnable): Thread {
        return Thread(threadGroup, runnable, namePrefix + threadNumber.getAndIncrement(), 0)
                .apply {
                    if (isDaemon) {
                        isDaemon = false
                    }
                    if (priority != Thread.NORM_PRIORITY) {
                        priority = Thread.NORM_PRIORITY
                    }
                }
    }

    companion object {
        private val POOL_NUMBER = AtomicInteger(1)
    }
}
