package com.genimee.android.utils.threads

import java.util.concurrent.LinkedBlockingQueue
import java.util.concurrent.ThreadPoolExecutor

/**
 * Creates a TaskQueue with a capacity of
 * [Integer.MAX_VALUE].
 */
class ScalingQueue<E> : LinkedBlockingQueue<E>() {
    /**
     * The executor this Queue belongs to.
     */
    private lateinit var executor: ThreadPoolExecutor

    /**
     * Sets the executor this queue belongs to.
     */
    fun setThreadPoolExecutor(executor: ThreadPoolExecutor) {
        this.executor = executor
    }

    /**
     * Inserts the specified element at the tail of this queue if there is at
     * least one available thread to run the current task. If all pool threads
     * are actively busy, it rejects the offer.
     *
     * @param element the element to add.
     * @return true if it was possible to add the element to this
     * queue, else false
     * @see ThreadPoolExecutor.execute
     */
    override fun offer(element: E): Boolean {
        val allWorkingThreads = executor.activeCount + super.size
        return allWorkingThreads < executor.poolSize && super.offer(element)
    }
}
