package com.example.jodatimed8test;

import android.app.Activity;
import android.os.Bundle;
import android.text.Html;
import android.view.View;
import android.widget.TextView;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class MainActivity extends Activity {

    private static final String[] DATETIMES_TO_PARSE = {
            "2018-03-01 22:30:00",
            "2018-03-02 00:00:00",
            "2018-03-02 00:00:00",
            "2018-03-02 00:20:00",
            "2018-03-02 00:20:00",
            "2018-03-02 01:10:00",
            "2018-03-02 01:10:00",
            "2018-03-02 02:00:00",
            "2018-03-02 02:00:00",
            "2018-03-02 03:00:00",
            "2018-03-02 03:00:00",
            "2018-03-02 03:50:00",
            "2018-03-02 03:50:00",
            "2018-03-02 04:20:00",
            "2018-03-02 04:20:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:55:00",
            "2018-03-02 05:55:00",
            "2018-03-02 10:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 13:00:00",
            "2018-03-02 13:00:00",
            "2018-03-02 13:15:00",
            "2018-03-02 13:15:00",
            "2018-03-02 13:40:00",
            "2018-03-02 13:40:00",
            "2018-03-02 14:05:00",
            "2018-03-02 14:05:00",
            "2018-03-02 14:30:00",
            "2018-03-02 14:30:00",
            "2018-03-02 15:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 18:00:00",
            "2018-03-02 18:00:00",
            "2018-03-02 18:30:00",
            "2018-03-02 18:30:00",
            "2018-03-02 19:35:00",
            "2018-03-02 19:35:00",
            "2018-03-02 20:40:00",
            "2018-03-02 20:40:00",
            "2018-03-02 20:55:00",
            "2018-03-02 20:55:00",
            "2018-03-02 22:00:00",
            "2018-03-02 22:00:00",
            "2018-03-02 23:00:00",
            "2018-03-02 23:00:00",
            "2018-03-03 00:00:00",
            "2018-03-03 00:00:00",
            "2018-03-03 00:20:00",
            "2018-03-03 00:20:00",
            "2018-03-03 04:10:00",
            "2018-03-01 23:00:00",
            "2018-03-01 23:40:00",
            "2018-03-01 23:40:00",
            "2018-03-02 00:40:00",
            "2018-03-02 00:40:00",
            "2018-03-02 01:30:00",
            "2018-03-02 01:30:00",
            "2018-03-02 02:00:00",
            "2018-03-02 02:00:00",
            "2018-03-02 02:30:00",
            "2018-03-02 02:30:00",
            "2018-03-02 03:30:00",
            "2018-03-02 03:30:00",
            "2018-03-02 04:00:00",
            "2018-03-02 04:00:00",
            "2018-03-02 04:30:00",
            "2018-03-02 04:30:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 06:00:00",
            "2018-03-02 06:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:05:00",
            "2018-03-02 07:05:00",
            "2018-03-02 07:15:00",
            "2018-03-02 07:15:00",
            "2018-03-02 07:20:00",
            "2018-03-02 07:20:00",
            "2018-03-02 07:30:00",
            "2018-03-02 07:30:00",
            "2018-03-02 07:45:00",
            "2018-03-02 07:45:00",
            "2018-03-02 08:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 08:05:00",
            "2018-03-02 08:05:00",
            "2018-03-02 08:15:00",
            "2018-03-02 08:15:00",
            "2018-03-02 08:20:00",
            "2018-03-02 08:20:00",
            "2018-03-02 08:30:00",
            "2018-03-02 08:30:00",
            "2018-03-02 08:35:00",
            "2018-03-02 08:35:00",
            "2018-03-02 08:45:00",
            "2018-03-02 08:45:00",
            "2018-03-02 08:50:00",
            "2018-03-02 08:50:00",
            "2018-03-02 09:00:00",
            "2018-03-02 09:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 11:00:00",
            "2018-03-02 11:00:00",
            "2018-03-02 11:30:00",
            "2018-03-02 11:30:00",
            "2018-03-02 12:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 15:15:00",
            "2018-03-02 15:15:00",
            "2018-03-02 15:30:00",
            "2018-03-02 15:30:00",
            "2018-03-02 16:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 16:30:00",
            "2018-03-02 16:30:00",
            "2018-03-02 17:15:00",
            "2018-03-02 17:15:00",
            "2018-03-02 19:00:00",
            "2018-03-02 19:00:00",
            "2018-03-02 21:05:00",
            "2018-03-02 21:05:00",
            "2018-03-02 23:50:00",
            "2018-03-02 23:50:00",
            "2018-03-03 01:30:00",
            "2018-03-03 01:30:00",
            "2018-03-03 02:00:00",
            "2018-03-01 22:00:00",
            "2018-03-01 23:45:00",
            "2018-03-01 23:45:00",
            "2018-03-02 00:45:00",
            "2018-03-02 00:45:00",
            "2018-03-02 02:00:00",
            "2018-03-02 02:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 06:30:00",
            "2018-03-02 06:30:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 09:00:00",
            "2018-03-02 09:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 13:00:00",
            "2018-03-02 13:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 17:30:00",
            "2018-03-02 17:30:00",
            "2018-03-02 18:00:00",
            "2018-03-02 18:00:00",
            "2018-03-02 20:00:00",
            "2018-03-02 20:00:00",
            "2018-03-02 20:30:00",
            "2018-03-02 20:30:00",
            "2018-03-02 22:30:00",
            "2018-03-02 22:30:00",
            "2018-03-02 22:40:00",
            "2018-03-02 22:40:00",
            "2018-03-02 23:00:00",
            "2018-03-02 23:00:00",
            "2018-03-03 00:30:00",
            "2018-03-03 00:30:00",
            "2018-03-03 01:30:00",
            "2018-03-03 01:30:00",
            "2018-03-03 02:30:00",
            "2018-03-01 22:40:00",
            "2018-03-01 23:20:00",
            "2018-03-01 23:20:00",
            "2018-03-02 01:00:00",
            "2018-03-02 01:00:00",
            "2018-03-02 02:20:00",
            "2018-03-02 02:20:00",
            "2018-03-02 03:10:00",
            "2018-03-02 03:10:00",
            "2018-03-02 03:50:00",
            "2018-03-02 03:50:00",
            "2018-03-02 04:50:00",
            "2018-03-02 04:50:00",
            "2018-03-02 05:50:00",
            "2018-03-02 05:50:00",
            "2018-03-02 07:30:00",
            "2018-03-02 07:30:00",
            "2018-03-02 08:10:00",
            "2018-03-02 08:10:00",
            "2018-03-02 08:50:00",
            "2018-03-02 08:50:00",
            "2018-03-02 09:40:00",
            "2018-03-02 09:40:00",
            "2018-03-02 10:10:00",
            "2018-03-02 10:10:00",
            "2018-03-02 11:10:00",
            "2018-03-02 11:10:00",
            "2018-03-02 13:30:00",
            "2018-03-02 13:30:00",
            "2018-03-02 14:30:00",
            "2018-03-02 14:30:00",
            "2018-03-02 15:40:00",
            "2018-03-02 15:40:00",
            "2018-03-02 17:10:00",
            "2018-03-02 17:10:00",
            "2018-03-02 18:00:00",
            "2018-03-02 18:00:00",
            "2018-03-02 18:50:00",
            "2018-03-02 18:50:00",
            "2018-03-02 19:30:00",
            "2018-03-02 19:30:00",
            "2018-03-02 20:15:00",
            "2018-03-02 20:15:00",
            "2018-03-02 21:00:00",
            "2018-03-02 21:00:00",
            "2018-03-02 22:00:00",
            "2018-03-02 22:00:00",
            "2018-03-02 22:40:00",
            "2018-03-02 22:40:00",
            "2018-03-02 23:20:00",
            "2018-03-02 23:20:00",
            "2018-03-03 00:50:00",
            "2018-03-03 00:50:00",
            "2018-03-03 02:20:00",
            "2018-03-01 22:50:00",
            "2018-03-01 23:50:00",
            "2018-03-01 23:50:00",
            "2018-03-02 01:45:00",
            "2018-03-02 01:45:00",
            "2018-03-02 02:45:00",
            "2018-03-02 02:45:00",
            "2018-03-02 03:45:00",
            "2018-03-02 03:45:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:30:00",
            "2018-03-02 05:30:00",
            "2018-03-02 06:00:00",
            "2018-03-02 06:00:00",
            "2018-03-02 06:30:00",
            "2018-03-02 06:30:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:30:00",
            "2018-03-02 07:30:00",
            "2018-03-02 08:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 11:00:00",
            "2018-03-02 11:00:00",
            "2018-03-02 12:15:00",
            "2018-03-02 12:15:00",
            "2018-03-02 13:00:00",
            "2018-03-02 13:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 15:50:00",
            "2018-03-02 15:50:00",
            "2018-03-02 16:45:00",
            "2018-03-02 16:45:00",
            "2018-03-02 17:45:00",
            "2018-03-02 17:45:00",
            "2018-03-02 18:00:00",
            "2018-03-02 18:00:00",
            "2018-03-02 19:00:00",
            "2018-03-02 19:00:00",
            "2018-03-02 20:00:00",
            "2018-03-02 20:00:00",
            "2018-03-02 21:00:00",
            "2018-03-02 21:00:00",
            "2018-03-02 21:50:00",
            "2018-03-02 21:50:00",
            "2018-03-02 23:15:00",
            "2018-03-02 23:15:00",
            "2018-03-03 02:00:00",
            "2018-03-01 22:50:00",
            "2018-03-02 01:15:00",
            "2018-03-02 01:15:00",
            "2018-03-02 03:00:00",
            "2018-03-02 03:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 06:00:00",
            "2018-03-02 06:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 09:00:00",
            "2018-03-02 09:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 17:30:00",
            "2018-03-02 17:30:00",
            "2018-03-02 18:30:00",
            "2018-03-02 18:30:00",
            "2018-03-02 18:45:00",
            "2018-03-02 18:45:00",
            "2018-03-02 19:55:00",
            "2018-03-02 19:55:00",
            "2018-03-02 21:00:00",
            "2018-03-02 21:00:00",
            "2018-03-02 23:00:00",
            "2018-03-02 23:00:00",
            "2018-03-03 01:00:00",
            "2018-03-03 01:00:00",
            "2018-03-03 03:00:00",
            "2018-03-01 21:00:00",
            "2018-03-02 00:45:00",
            "2018-03-02 00:45:00",
            "2018-03-02 01:45:00",
            "2018-03-02 01:45:00",
            "2018-03-02 03:30:00",
            "2018-03-02 03:30:00",
            "2018-03-02 04:30:00",
            "2018-03-02 04:30:00",
            "2018-03-02 06:00:00",
            "2018-03-02 06:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 17:20:00",
            "2018-03-02 17:20:00",
            "2018-03-02 17:30:00",
            "2018-03-02 17:30:00",
            "2018-03-02 19:45:00",
            "2018-03-02 19:45:00",
            "2018-03-02 21:00:00",
            "2018-03-02 21:00:00",
            "2018-03-03 00:00:00",
            "2018-03-03 00:00:00",
            "2018-03-03 01:45:00",
            "2018-03-03 01:45:00",
            "2018-03-03 04:00:00",
            "2018-03-01 22:00:00",
            "2018-03-02 00:00:00",
            "2018-03-02 00:00:00",
            "2018-03-02 01:00:00",
            "2018-03-02 01:00:00",
            "2018-03-02 03:15:00",
            "2018-03-02 03:15:00",
            "2018-03-02 04:45:00",
            "2018-03-02 04:45:00",
            "2018-03-02 06:00:00",
            "2018-03-02 06:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 11:20:00",
            "2018-03-02 11:20:00",
            "2018-03-02 11:30:00",
            "2018-03-02 11:30:00",
            "2018-03-02 14:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 15:30:00",
            "2018-03-02 15:30:00",
            "2018-03-02 15:45:00",
            "2018-03-02 15:45:00",
            "2018-03-02 18:30:00",
            "2018-03-02 18:30:00",
            "2018-03-02 20:00:00",
            "2018-03-02 20:00:00",
            "2018-03-02 21:50:00",
            "2018-03-02 21:50:00",
            "2018-03-02 22:00:00",
            "2018-03-02 22:00:00",
            "2018-03-03 00:45:00",
            "2018-03-03 00:45:00",
            "2018-03-03 02:15:00",
            "2018-03-01 22:00:00",
            "2018-03-01 23:30:00",
            "2018-03-01 23:30:00",
            "2018-03-02 01:30:00",
            "2018-03-02 01:30:00",
            "2018-03-02 02:00:00",
            "2018-03-02 02:00:00",
            "2018-03-02 03:00:00",
            "2018-03-02 03:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 05:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 07:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 11:00:00",
            "2018-03-02 11:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 12:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 15:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 19:00:00",
            "2018-03-02 19:00:00",
            "2018-03-02 20:00:00",
            "2018-03-02 20:00:00",
            "2018-03-02 21:00:00",
            "2018-03-02 21:00:00",
            "2018-03-02 22:00:00",
            "2018-03-02 22:00:00",
            "2018-03-02 23:00:00",
            "2018-03-02 23:00:00",
            "2018-03-03 01:00:00",
            "2018-03-03 01:00:00",
            "2018-03-03 02:00:00",
            "2018-03-01 23:00:00",
            "2018-03-02 00:00:00",
            "2018-03-02 00:00:00",
            "2018-03-02 00:40:00",
            "2018-03-02 00:40:00",
            "2018-03-02 02:20:00",
            "2018-03-02 02:20:00",
            "2018-03-02 03:20:00",
            "2018-03-02 03:20:00",
            "2018-03-02 04:00:00",
            "2018-03-02 04:00:00",
            "2018-03-02 05:10:00",
            "2018-03-02 05:10:00",
            "2018-03-02 06:10:00",
            "2018-03-02 06:10:00",
            "2018-03-02 06:40:00",
            "2018-03-02 06:40:00",
            "2018-03-02 07:50:00",
            "2018-03-02 07:50:00",
            "2018-03-02 08:00:00",
            "2018-03-02 08:00:00",
            "2018-03-02 09:00:00",
            "2018-03-02 09:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 10:00:00",
            "2018-03-02 11:40:00",
            "2018-03-02 11:40:00",
            "2018-03-02 12:50:00",
            "2018-03-02 12:50:00",
            "2018-03-02 14:00:00",
            "2018-03-02 14:00:00",
            "2018-03-02 14:40:00",
            "2018-03-02 14:40:00",
            "2018-03-02 15:20:00",
            "2018-03-02 15:20:00",
            "2018-03-02 15:50:00",
            "2018-03-02 15:50:00",
            "2018-03-02 16:00:00",
            "2018-03-02 16:00:00",
            "2018-03-02 17:10:00",
            "2018-03-02 17:10:00",
            "2018-03-02 19:00:00",
            "2018-03-02 19:00:00",
            "2018-03-02 20:10:00",
            "2018-03-02 20:10:00",
            "2018-03-02 20:50:00",
            "2018-03-02 20:50:00",
            "2018-03-02 21:00:00",
            "2018-03-02 21:00:00",
            "2018-03-02 22:00:00",
            "2018-03-02 22:00:00",
            "2018-03-02 22:40:00",
            "2018-03-02 22:40:00",
            "2018-03-02 23:00:00",
            "2018-03-02 23:00:00",
            "2018-03-03 00:00:00",
            "2018-03-03 00:00:00",
            "2018-03-03 01:50:00",
            "2018-03-03 01:50:00",
            "2018-03-03 02:30:00"};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        final TextView resultsTv = findViewById(R.id.results);

        findViewById(R.id.parseStrings).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                DateTimeFormatter df = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");
                StringBuilder result = new StringBuilder();

                for (String dateTime : DATETIMES_TO_PARSE) {
                    result.append("Original dateTime: ").append(dateTime).append("<br>");

                    DateTime parsed = df.parseDateTime(dateTime);
                    boolean wrongResult = parsed.getHourOfDay() == 0 && parsed.getMinuteOfHour() == 0 && parsed.getSecondOfMinute() == 0 && !dateTime.contains("00:00:00");
                    if (wrongResult) {
                        result.append("<font color=\"red\">");
                    }
                    result.append("parsed.toString(): ").append(parsed.toString());
                    if (wrongResult) {
                        result.append("</font>");
                    }

                    result.append("<br><br>");
                }

                resultsTv.setText(Html.fromHtml(result.toString()));
            }
        });
    }
}
