package com.example.nemanja.newloadersproblems;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity  implements LoaderManager.LoaderCallbacks<Object> {
    private static final String TAG = "MainActivity";
    private TextView mTextView;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        mTextView = findViewById(R.id.startActBtn);

        mTextView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                startActivity(new Intent(MainActivity.this, SecondActivity.class));
            }
        });

        getSupportLoaderManager().initLoader(1, null, this);
    }

    @NonNull
    @Override
    public Loader<Object> onCreateLoader(int id, Bundle args) {
        Log.d(TAG, "onCreateLoader: ");
        return new SampleLoaderSupport(this);
    }

    static int sNumberOfCalls = 0;
    @SuppressLint("SetTextI18n")
    @Override
    public void onLoadFinished(@NonNull Loader<Object> loader, Object data) {
        Log.d(TAG, "onLoadFinished() called with: loader = [" + loader + "], data = [" + data + "]");

        ((TextView) findViewById(R.id.textView)).setText("Number of 'onLoadFinished' calls: " +
                ++sNumberOfCalls + "; value = " + data);
    }

    @Override
    public void onLoaderReset(@NonNull Loader<Object> loader) {
        Log.d(TAG, "onLoaderReset() called with: loader = [" + loader + "]");
    }
}
