package com.example.nemanja.newloadersproblems;

import android.content.Context;
import android.os.SystemClock;
import android.support.v4.content.AsyncTaskLoader;
import android.util.Log;

import java.util.concurrent.atomic.AtomicInteger;

class SampleLoaderSupport extends AsyncTaskLoader<Object> {
    private final String TAG = super.toString();

    static AtomicInteger sSequence = new AtomicInteger(42);

    Object result = null;


    public SampleLoaderSupport(Context context) {
        super(context);
    }

    @Override
    public Object loadInBackground() {
        Log.i(TAG, "Time consuming loadInBackground!");
        SystemClock.sleep(1000);
        return sSequence.getAndIncrement();
    }

    @Override
    public void deliverResult(Object data) {
        Log.d(TAG, "deliverResult: ");
        result = data;
        super.deliverResult(data);
    }

    @Override
    protected void onStartLoading() {
        Log.d(TAG, "onStartLoading: ");
        if (result != null) {
            deliverResult(result);
        }

        if (takeContentChanged() || result == null) {
            forceLoad();
        }
    }

    @Override
    protected void onAbandon() {
        super.onAbandon();
        cancelLoad();
    }

    @Override
    protected void onReset() {
        Log.d(TAG, "onReset: ");
        super.onReset();

        cancelLoad();

        result = null;
    }
}
