package com.android.myapplication

import android.content.Context
import android.os.Bundle
import android.util.Log
import androidx.appcompat.app.AppCompatActivity
import androidx.loader.app.LoaderManager
import androidx.loader.content.Loader
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity() {
    companion object {
        val LOADER_ID = AsyncTaskLoaderEx.getNewUniqueLoaderId()
    }


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        textView.text = "loading"

        LoaderManager.getInstance(this).initLoader(LOADER_ID, null, object : LoaderManager.LoaderCallbacks<Long> {
            override fun onCreateLoader(id: Int, args: Bundle?): Loader<Long> = SomeLoader(this@MainActivity)


            override fun onLoadFinished(loader: Loader<Long>, data: Long?) {
                Log.d("AppLog", "got result:$data")
                textView.text = "result:$data"
            }

            override fun onLoaderReset(loader: Loader<Long>) {
            }

        })
    }

    class SomeLoader(context: Context) : AsyncTaskLoaderEx<Long>(context) {
        override fun loadInBackground(): Long {
            val result = System.currentTimeMillis()
            Thread.sleep(5000)
            return result
        }

    }
}
