package fr.openium.testworkmanager

import android.app.job.JobScheduler
import android.content.Context
import android.os.AsyncTask
import android.os.Build
import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.view.Gravity
import androidx.work.*
import io.reactivex.Observable
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.disposables.Disposable
import kotlinx.android.synthetic.main.activity_main.*
import java.util.concurrent.TimeUnit

class MainActivity : AppCompatActivity() {

    var disposable: Disposable? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        AsyncTask.execute {
            val workManager = WorkManager.getInstance().synchronous()
            schedulePeriodicTaskDaily<TestJob1>(workManager)
            schedulePeriodicTaskDaily<TestJob2>(workManager)
            schedulePeriodicTaskDaily<TestJob3>(workManager)
            schedulePeriodicTaskDaily<TestJob4>(workManager)
            schedulePeriodicTaskDaily<TestJob5>(workManager)
        }
    }

    override fun onStart() {
        super.onStart()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            disposable = Observable.interval(0, 5, TimeUnit.SECONDS).map {
                val jobScheduler = getSystemService(Context.JOB_SCHEDULER_SERVICE) as JobScheduler
                val jobSchedulerCount = jobScheduler.allPendingJobs.count()

                val workManager = WorkManager.getInstance().synchronous()
                val job1Count =
                    workManager.getStatusesByTagSync(TestJob1::class.java.simpleName).count()
                val job2Count =
                    workManager.getStatusesByTagSync(TestJob2::class.java.simpleName).count()
                val job3Count =
                    workManager.getStatusesByTagSync(TestJob3::class.java.simpleName).count()
                val job4Count =
                    workManager.getStatusesByTagSync(TestJob4::class.java.simpleName).count()
                val job5Count =
                    workManager.getStatusesByTagSync(TestJob5::class.java.simpleName).count()

                "jobScheduler count: $jobSchedulerCount\n" +
                        "job1 count: $job1Count\n" +
                        "job2 count: $job2Count\n" +
                        "job3 count: $job3Count\n" +
                        "job4 count: $job4Count\n" +
                        "job5 count: $job5Count\n"
            }.observeOn(AndroidSchedulers.mainThread()).subscribe {
                textViewJob.gravity = Gravity.CENTER
                textViewJob.text = it
            }
        }
    }

    override fun onStop() {
        super.onStop()
        disposable?.dispose()
    }

    private inline fun <reified T : Worker> schedulePeriodicTaskDaily(
        workManager: SynchronousWorkManager
    ) {
        val statuses = workManager.getStatusesByTagSync(T::class.java.simpleName)
        if (statuses.count() == 0 || statuses.all { it.state.isFinished }) {
            val worker =
                PeriodicWorkRequestBuilder<T>(6, TimeUnit.HOURS)
                    .addTag(T::class.java.simpleName)
                    .setConstraints(Constraints.Builder().setRequiredNetworkType(NetworkType.UNMETERED).build())
                    .build()
            workManager.enqueueSync(worker)
        }
    }
}
