package com.example.deeplinkbackstackissue

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.navigation.NavController
import androidx.navigation.findNavController
import kotlinx.android.synthetic.main.article_list_fragment.*


class ArticleListFragment : Fragment() {

    companion object {
        fun newInstance() = ArticleListFragment()
    }

    private lateinit var viewModel: ArticleListViewModel

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.article_list_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(ArticleListViewModel::class.java)
        // TODO: Use the ViewModel
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val navController = view.findNavController()
        articleList_article1Button.setOnClickListener(createClickListenerForArgs(navController, "1"))
        articleList_article2Button.setOnClickListener(createClickListenerForArgs(navController, "2"))
        articleList_article3Button.setOnClickListener(createClickListenerForArgs(navController, "3"))
        articleList_article4Button.setOnClickListener(createClickListenerForArgs(navController, "4"))
        articleList_article5Button.setOnClickListener(createClickListenerForArgs(navController, "5"))
    }

    private fun createClickListenerForArgs(navController: NavController, articleId: String): View.OnClickListener {
        return View.OnClickListener {
            ArticleListFragmentDirections.showArticleAction().apply {
                setArticleId(articleId)
                navController.navigate(this)
            }
        }
    }
}
