package com.example.deeplinkbackstackissue

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.navigation.NavController
import androidx.navigation.findNavController
import kotlinx.android.synthetic.main.issue_list_fragment.*


class IssueListFragment : Fragment() {

    companion object {
        fun newInstance() = IssueListFragment()
    }

    private lateinit var viewModel: IssueListViewModel

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.issue_list_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(IssueListViewModel::class.java)
        // TODO: Use the ViewModel
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val navController = view.findNavController()
        issueList_issue1Button.setOnClickListener(createClickListenerForArgs(navController, "1"))
        issueList_issue2Button.setOnClickListener(createClickListenerForArgs(navController, "2"))
        issueList_issue3Button.setOnClickListener(createClickListenerForArgs(navController, "3"))
        issueList_issue4Button.setOnClickListener(createClickListenerForArgs(navController, "4"))
        issueList_issue5Button.setOnClickListener(createClickListenerForArgs(navController, "5"))
    }

    private fun createClickListenerForArgs(navController: NavController, issueId: String): View.OnClickListener {
        return View.OnClickListener {
            IssueListFragmentDirections.showIssueAction().apply {
                setIssueId(issueId)
                navController.navigate(this)
            }
        }
    }
}
